/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "Log.h"
#include "WindowSystems/InputEventProcessingState.h"

using namespace std;
using namespace InputEventProcessing;
using namespace LayerManagerCalibration;

InputEventProcessingState::InputEventProcessingState()
{
}

InputEventProcessingState::~InputEventProcessingState()
{
}

Subdivision* InputEventProcessingState::getActiveSubdivision(
        evdev_input_device* device,
        uint slot)
{
    map<pair<evdev_input_device*,uint>, Subdivision*>::iterator match;

    match = m_subdivisions.find(pair<evdev_input_device*, uint>(device, slot));

    if (match != m_subdivisions.end())
    {
        return match->second;
    }
    else
    {
        return NULL;
    }
}

void InputEventProcessingState::setActiveSubdivision(evdev_input_device* device,
        uint slot,
        Subdivision* subdivision)
{
    LOG_DEBUG("InputEventProcessingState",
              "Subdivision name="
              << (subdivision != NULL ? subdivision->getName() : "NULL"));

    m_subdivisions[pair<evdev_input_device*, uint>(device, slot)] = subdivision;
}
